/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2artifacts.content.search.token;

import dev.xkmc.l2artifacts.content.config.StatTypeConfig;
import dev.xkmc.l2artifacts.content.core.ArtifactSet;
import dev.xkmc.l2artifacts.content.core.ArtifactSlot;
import dev.xkmc.l2artifacts.content.core.BaseArtifact;
import dev.xkmc.l2artifacts.content.misc.ArtifactChestItem;
import dev.xkmc.l2artifacts.content.search.token.ArtifactFilter;
import dev.xkmc.l2artifacts.content.search.token.AttributeFilter;
import dev.xkmc.l2artifacts.content.search.token.IArtifactFeature;
import dev.xkmc.l2artifacts.content.search.token.IArtifactFilter;
import dev.xkmc.l2artifacts.content.search.token.RankFilter;
import dev.xkmc.l2artifacts.content.search.token.RankToken;
import dev.xkmc.l2artifacts.content.search.token.SimpleArtifactFilter;
import dev.xkmc.l2artifacts.init.data.LangData;
import dev.xkmc.l2artifacts.init.registrate.ArtifactTypeRegistry;
import dev.xkmc.l2library.util.code.GenericItemStack;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.l2serial.serialization.codec.TagCodec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

@SerialClass
public class ArtifactChestToken
implements IArtifactFilter {
    public final ItemStack stack;
    public final int invSlot;
    public final List<ItemStack> list;
    public final List<ArtifactFilter<?>> filters = new ArrayList();
    @SerialClass.SerialField
    public final ArtifactFilter<RankToken> rank;
    @SerialClass.SerialField
    public final ArtifactFilter<ArtifactSet> set;
    @SerialClass.SerialField
    public final ArtifactFilter<ArtifactSlot> slot;
    @SerialClass.SerialField
    public final ArtifactFilter<StatTypeConfig> stat;
    public int exp = 0;
    @Nullable
    private List<GenericItemStack<BaseArtifact>> cahce = null;

    public static ArtifactChestToken of(Player player, int invSlot) {
        ItemStack stack = player.m_150109_().m_8020_(invSlot);
        List<ItemStack> list = ArtifactChestItem.getContent(stack);
        ArtifactChestToken ans = new ArtifactChestToken(stack, list, invSlot);
        TagCodec.fromTag((CompoundTag)ArtifactChestItem.getFilter(stack), ArtifactChestToken.class, (Object)ans, e -> true);
        ans.exp = ArtifactChestItem.getExp(stack);
        return ans;
    }

    private ArtifactChestToken(ItemStack stack, List<ItemStack> list, int invSlot) {
        this.list = list;
        this.stack = stack;
        this.invSlot = invSlot;
        this.rank = this.addFilter(e -> new RankFilter((IArtifactFilter)e, LangData.FILTER_RANK));
        this.set = this.addFilter(e -> new SimpleArtifactFilter<ArtifactSet>((IArtifactFilter)e, LangData.FILTER_SET, (Iterable<ArtifactSet>)ArtifactTypeRegistry.SET.get(), i -> i.set.get()));
        this.slot = this.addFilter(e -> new SimpleArtifactFilter<ArtifactSlot>((IArtifactFilter)e, LangData.FILTER_SLOT, (Iterable<ArtifactSlot>)ArtifactTypeRegistry.SLOT.get(), i -> i.slot.get()));
        this.stat = this.addFilter(e -> new AttributeFilter((IArtifactFilter)e, LangData.FILTER_STAT, StatTypeConfig.getValues()));
        TagCodec.fromTag((CompoundTag)ArtifactChestItem.getFilter(stack), ArtifactChestToken.class, (Object)this, e -> true);
    }

    private <T extends IArtifactFeature> ArtifactFilter<T> addFilter(Function<IArtifactFilter, ArtifactFilter<T>> gen) {
        ArtifactFilter<T> ans = gen.apply(this.filters.isEmpty() ? this : (IArtifactFilter)this.filters.get(this.filters.size() - 1));
        this.filters.add(ans);
        return ans;
    }

    @Override
    public void update() {
        this.cahce = null;
        this.rank.clearCache();
        this.set.clearCache();
        this.slot.clearCache();
        this.stat.clearCache();
    }

    public void prioritize(int ind) {
        this.filters.get((int)ind).sort_priority = 0;
        ArrayList list = new ArrayList(this.filters);
        list.sort(Comparator.comparingInt(e -> e.sort_priority));
        for (int i = 0; i < list.size(); ++i) {
            ((ArtifactFilter)list.get((int)i)).sort_priority = i + 1;
        }
    }

    @Override
    public Comparator<GenericItemStack<BaseArtifact>> getComparator() {
        ArrayList list = new ArrayList(this.filters);
        list.sort(Comparator.comparingInt(e -> e.sort_priority));
        Comparator<GenericItemStack<BaseArtifact>> ans = null;
        assert (!list.isEmpty());
        for (ArtifactFilter<?> e2 : list) {
            if (ans == null) {
                ans = e2.getComparator();
                continue;
            }
            ans = ans.thenComparing(e2.getComparator());
        }
        return ans;
    }

    @Override
    @Deprecated
    public Stream<GenericItemStack<BaseArtifact>> getAvailableArtifacts() {
        return this.list.stream().map(e -> new GenericItemStack((Item)((BaseArtifact)e.m_41720_()), e));
    }

    public List<GenericItemStack<BaseArtifact>> getFiltered() {
        if (this.cahce != null) {
            return this.cahce;
        }
        this.cahce = this.stat.getAvailableArtifacts().sorted(this.getComparator()).toList();
        return this.cahce;
    }

    public void save() {
        ArtifactChestItem.setContent(this.stack, this.list);
    }
}

